/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright (c) 2015 Adobe Systems Incorporated. All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */


/*jslint vars: true, plusplus: true, devel: true, nomen: true, indent: 4,
maxerr: 50, node: true */
/*global */
(function () {
    "use strict";
    
    var fs     = require('fs'),
        path   = require('path');
    
    var watchedList = {};
    
    /**
     * Check if the child path is a subpath of the parent patch
     * @param   {string} parentPath 
     * @param   {string} childPath  
     * @returns {boolean}  True if child is subpath Of Parent
     */
    var _isSubPathOf = function (parentPath, childPath) {
        var parentNormPath = path.normalize(parentPath),
            childNormPath  = path.normalize(childPath);
        if (childNormPath.length >= parentNormPath.length) {
            return childNormPath.indexOf(parentPath) === 0 ? true : false;
        }
        return false;
    };
    
    /**
     * checks is the path is in the watched path list
     * @param {string} path 
     */
    var isPathBeingWatched = function (path) {
        var property = "";
        for (property in watchedList) {
            if (watchedList.hasOwnProperty(property) && _isSubPathOf(property, path)) {
                return true;
            }
        }
        return false;
    };
    
    /**
     * Adds the path to the watched path list if it is not already being watched
     * @param {string}   path 
     * @param {object}   data[optional] to be stored along the path
     */
    var addWatchedPath = function (path, data) {
        if (!isPathBeingWatched(path)) {
            watchedList[path] = data || true;
        }
    };
    
    /**
     * removes the path from the watched path list and returns the optional watched path data
     * @param   {string}   path 
     * @returns {object}   optional data object if stored or undefined
     */
    var removeWatchedPath = function (path) {
        if (isPathBeingWatched(path) && watchedList[path]) {
            var data = watchedList[path];
            delete watchedList[path];
            return data;
        }
    };
    
    /**
     * returns the optional watched path data or undefined if no data can be found
     * @param   {string} path 
     * @returns {object} optional data object if stored or undefined
     */
    var getWatchedPathData = function (path) {
        if (isPathBeingWatched(path) && watchedList[path]) {
            return watchedList[path];
        }
    };
    
    exports.addWatchedPath     = addWatchedPath;
    exports.isPathBeingWatched = isPathBeingWatched;
    exports.removeWatchedPath  = removeWatchedPath;
}());
